﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
using DataAccess;
using Newtonsoft;
using Newtonsoft.Json;
using System;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml;
using System.Xml.Linq;

/// <summary>
/// Statistical Analysis reports methods and properties
/// </summary>
public class CReportsStat
{
    /// <summary>
    /// BaseMaster property
    /// </summary>
    private BaseMaster m_BaseMstr = null;

    /// <summary>
    /// Constructor takes a BaseMaster
    /// </summary>
    /// <param name="BaseMstr"></param>
	public CReportsStat(BaseMaster BaseMstr)
	{
        m_BaseMstr = BaseMstr;
	}

    /// <summary>
    /// US: 8064. Create the export request in the database.
    /// </summary>
    /// <param name="strExportRequestName"></param>
    /// <returns></returns>
    public DataSet CreateExportRequestDS(string strExportRequestName)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(m_BaseMstr.ASPSessionID,
                                                          m_BaseMstr.ClientIP,
                                                          m_BaseMstr.FXUserID);

        plist.AddInputParameter("pi_vExportRequestName", strExportRequestName);

        //
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(m_BaseMstr.DBConn,
                                           "PCK_REPORTS_STAT.CreateExportRequestRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);


        //set the base master status code and status for display
        m_BaseMstr.StatusCode = lStatusCode;
        m_BaseMstr.StatusComment = strStatusComment;
        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }

    /// <summary>
    /// US: 7991. Get a list the request for this user.
    /// </summary>
    /// <returns></returns>
    public DataSet GetMyRequestDS()
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(m_BaseMstr.ASPSessionID,
                                                          m_BaseMstr.ClientIP,
                                                          m_BaseMstr.FXUserID);

        //
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(m_BaseMstr.DBConn,
                                           "PCK_REPORTS_STAT.GetMyRequestRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);

        //set the base master status code and status for display
        m_BaseMstr.StatusCode = lStatusCode;
        m_BaseMstr.StatusComment = strStatusComment;
        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }

    /// <summary>
    /// US: 8065. Rename export request.
    /// </summary>
    /// <param name="lRequestID"></param>
    /// <param name="strNewExportRequestName"></param>
    /// <returns></returns>
    public bool RenameExportRequest(long lRequestID,
                                    string strNewExportRequestName)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(m_BaseMstr.ASPSessionID,
                                                          m_BaseMstr.ClientIP,
                                                          m_BaseMstr.FXUserID);

        plist.AddInputParameter("pi_nRequestID", lRequestID);
        plist.AddInputParameter("pi_vNewExportRequestName", strNewExportRequestName);

        m_BaseMstr.DBConn.ExecuteOracleSP("PCK_REPORTS_STAT.RenameExportRequest",
                                          plist,
                                          out lStatusCode,
                                          out strStatusComment);

        //set the base master status code and status for display
        m_BaseMstr.StatusCode = lStatusCode;
        m_BaseMstr.StatusComment = strStatusComment;

        // 0 = success if strStatus is populated it will show on the screen
        // 1 to n are errors and we always show errors
        if (lStatusCode == 0)
        {
            return true;
        }

        return false;
    }

    /// <summary>
    /// US: 7991. Update Filters and DataFields selection.
    /// </summary>
    /// <param name="lRequestID"></param>
    /// <param name="strFilters"></param>
    /// <param name="strDataFields"></param>
    /// <returns></returns>
    public bool UpdateExportRequest(long lRequestID,
                                    string strFilters,
                                    string strDataFields)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(m_BaseMstr.ASPSessionID,
                                                          m_BaseMstr.ClientIP,
                                                          m_BaseMstr.FXUserID);

        plist.AddInputParameter("pi_nRequestID", lRequestID);
        plist.AddInputParameter("pi_vFilters", strFilters);
        plist.AddInputParameter("pi_vDataFields", strDataFields);

        m_BaseMstr.DBConn.ExecuteOracleSP("PCK_REPORTS_STAT.UpdateExportRequest",
                                          plist,
                                          out lStatusCode,
                                          out strStatusComment);

        //set the base master status code and status for display
        m_BaseMstr.StatusCode = lStatusCode;
        m_BaseMstr.StatusComment = strStatusComment;

        // 0 = success if strStatus is populated it will show on the screen
        // 1 to n are errors and we always show errors
        if (lStatusCode == 0)
        {
            return true;
        }

        return false;
    }

    /// <summary>
    /// US: 7991. Get export request filters and data selected.
    /// </summary>
    /// <param name="lRequestID"></param>
    /// <returns></returns>
    public DataSet GetExportRequestDS(long lRequestID)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(m_BaseMstr.ASPSessionID,
                                                          m_BaseMstr.ClientIP,
                                                          m_BaseMstr.FXUserID);

        plist.AddInputParameter("pi_nRequestID", lRequestID);

        //
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(m_BaseMstr.DBConn,
                                           "PCK_REPORTS_STAT.GetExportRequestRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);

        //set the base master status code and status for display
        m_BaseMstr.StatusCode = lStatusCode;
        m_BaseMstr.StatusComment = strStatusComment;
        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }

    /// <summary>
    /// US: 8080. Create a new "export request" base on another.
    /// </summary>
    /// <param name="strExportRequestName"></param>
    /// <param name="strFilters"></param>
    /// <param name="strDataFields"></param>
    /// <returns></returns>
    public bool SaveAsExportRequest(string strExportRequestName,
                                    string strFilters,
                                    string strDataFields)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(m_BaseMstr.ASPSessionID,
                                                          m_BaseMstr.ClientIP,
                                                          m_BaseMstr.FXUserID);

        plist.AddInputParameter("pi_vExportRequestName", strExportRequestName);
        plist.AddInputParameter("pi_vFilters", strFilters);
        plist.AddInputParameter("pi_vDataFields", strDataFields);

        m_BaseMstr.DBConn.ExecuteOracleSP("PCK_REPORTS_STAT.SaveAsExportRequest",
                                          plist,
                                          out lStatusCode,
                                          out strStatusComment);

        //set the base master status code and status for display
        m_BaseMstr.StatusCode = lStatusCode;
        m_BaseMstr.StatusComment = strStatusComment;

        // 0 = success if strStatus is populated it will show on the screen
        // 1 to n are errors and we always show errors
        if (lStatusCode == 0)
        {
            return true;
        }

        return false;
    }

    /// <summary>
    /// US: 7990. Submit "export request" to the CSV process.
    /// </summary>
    /// <param name="lRequestID"></param>
    /// <param name="strFilters"></param>
    /// <param name="strDataFields"></param>
    /// <returns></returns>
    public bool SubmitExportRequest(long lRequestID,
                                    string strFilters,
                                    string strDataFields)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(m_BaseMstr.ASPSessionID,
                                                          m_BaseMstr.ClientIP,
                                                          m_BaseMstr.FXUserID);

        plist.AddInputParameter("pi_vKey", m_BaseMstr.Key);
        plist.AddInputParameter("pi_nRequestID", lRequestID);
        plist.AddInputParameter("pi_vFilters", strFilters);
        plist.AddInputParameter("pi_vDataFields", strDataFields);

        m_BaseMstr.DBConn.ExecuteOracleSP("PCK_REPORTS_STAT.SubmitExportRequest",
                                          plist,
                                          out lStatusCode,
                                          out strStatusComment);

        //set the base master status code and status for display
        m_BaseMstr.StatusCode = lStatusCode;
        m_BaseMstr.StatusComment = strStatusComment;

        // 0 = success if strStatus is populated it will show on the screen
        // 1 to n are errors and we always show errors
        if (lStatusCode == 0)
        {
            return true;
        }

        return false;
    }

    /// <summary>
    /// US: 8081. Cancel "export request" with status = In Process
    /// </summary>
    /// <param name="lRequestID"></param>
    /// <returns></returns>
    public bool CancelExportRequest(long lRequestID)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(m_BaseMstr.ASPSessionID,
                                                          m_BaseMstr.ClientIP,
                                                          m_BaseMstr.FXUserID);

        plist.AddInputParameter("pi_nRequestID", lRequestID);

        m_BaseMstr.DBConn.ExecuteOracleSP("PCK_REPORTS_STAT.CancelExportRequest",
                                          plist,
                                          out lStatusCode,
                                          out strStatusComment);

        //set the base master status code and status for display
        m_BaseMstr.StatusCode = lStatusCode;
        m_BaseMstr.StatusComment = strStatusComment;

        // 0 = success if strStatus is populated it will show on the screen
        // 1 to n are errors and we always show errors
        if (lStatusCode == 0)
        {
            return true;
        }

        return false;
    }

    /// <summary>
    /// US: 8083. Get DataSet with the name and CSV report.
    /// </summary>
    /// <param name="lRequestID"></param>
    /// <returns></returns>
    public DataSet GetExportRequestCSVFileDS(long lRequestID)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(m_BaseMstr.ASPSessionID,
                                                          m_BaseMstr.ClientIP,
                                                          m_BaseMstr.FXUserID);

        plist.AddInputParameter("pi_nRequestID", lRequestID);

        //
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(m_BaseMstr.DBConn,
                                           "PCK_REPORTS_STAT.GetExportRequestCSVFileRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);

        //set the base master status code and status for display
        m_BaseMstr.StatusCode = lStatusCode;
        m_BaseMstr.StatusComment = strStatusComment;
        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }

    /// <summary>
    /// Submit new export request. This will create the request and start processing.
    /// </summary>
    /// <param name="strExportRequestName"></param>
    /// <param name="strFilters"></param>
    /// <param name="strDataFields"></param>
    /// <returns></returns>
    public bool SubmitNewExportRequest(string strExportRequestName,
                                       string strFilters,
                                       string strDataFields)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(m_BaseMstr.ASPSessionID,
                                                          m_BaseMstr.ClientIP,
                                                          m_BaseMstr.FXUserID);

        plist.AddInputParameter("pi_vKey", m_BaseMstr.Key);
        plist.AddInputParameter("pi_vExportRequestName", strExportRequestName);
        plist.AddInputParameter("pi_vFilters", strFilters);
        plist.AddInputParameter("pi_vDataFields", strDataFields);

        
        m_BaseMstr.DBConn.ExecuteOracleSP("PCK_REPORTS_STAT.SubmitNewExportRequest",
                                          plist,
                                          out lStatusCode,
                                          out strStatusComment);

        //set the base master status code and status for display
        m_BaseMstr.StatusCode = lStatusCode;
        m_BaseMstr.StatusComment = strStatusComment;

        // 0 = success if strStatus is populated it will show on the screen
        // 1 to n are errors and we always show errors
        if (lStatusCode == 0)
        {
            return true;
        }

        return false;

    }

}